/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.parties.party.member;

import java.util.UUID;
import javax.annotation.Nonnull;
import xaero.pac.common.parties.party.PartyPlayerInfo;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;

public class PartyMember
extends PartyPlayerInfo<PartyMember>
implements IPartyMember,
Comparable<PartyMember> {
    private static final int OWNER_ORDINAL = PartyMemberRank.values().length;
    private PartyMemberRank rank = PartyMemberRank.MEMBER;
    private final boolean owner;

    public PartyMember(UUID playerUUID, boolean owner) {
        super(playerUUID);
        this.owner = owner;
    }

    public void setRank(PartyMemberRank rank) {
        this.rank = rank;
    }

    @Override
    public boolean isOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public PartyMemberRank getRank() {
        return this.rank;
    }

    public String toString() {
        return String.format("[%s, %s, %s]", new Object[]{this.getUUID(), this.getUsername(), this.getRank()});
    }

    @Override
    public int compareTo(PartyMember o) {
        int otherRankNumber;
        int thisRankNumber = this.owner ? OWNER_ORDINAL : this.rank.ordinal();
        int n = otherRankNumber = o.owner ? OWNER_ORDINAL : o.rank.ordinal();
        if (thisRankNumber != otherRankNumber) {
            return thisRankNumber > otherRankNumber ? -1 : 1;
        }
        return this.getUsername().compareTo(o.getUsername());
    }
}

